<?php include "header1.php"; ?>

<!-- Glassmorphism Styles -->
<style>
    .top-main-wrapper .header-box {
        width: 100%;
        height: 65px;
        background-color: #1D1C29;
    }
    body {
        background: linear-gradient(135deg, #232526 0%, #414345 100%);
        font-family: 'Poppins', Arial, sans-serif;
    }
    .contact-section {
    padding: 60px 0;
    /* display: flex
; */
    margin-left: 0%;
    align-items: center;
    justify-content: center;
}
    .glass-card {
        background: rgba(255, 255, 255, 0.15);
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border-radius: 24px;
        border: 1px solid rgba(255, 255, 255, 0.18);
        padding: 40px 32px;
        max-width: 420px;
        margin: auto;
        color: #fff;
        transition: box-shadow 0.3s;
        position: relative;
        overflow: hidden;
    }
    .glass-card::before {
        content: '';
        position: absolute;
        top: -80px;
        right: -80px;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, #ff6a88 0%, #ff99ac 100%);
        opacity: 0.18;
        z-index: 0;
        border-radius: 50%;
    }
    .glass-card h4 {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 32px;
        letter-spacing: 1px;
        color: #fff;
        z-index: 1;
        position: relative;
    }
    .contact-detail-list {
        display: flex;
        flex-direction: column;
        gap: 32px;
        z-index: 1;
        position: relative;
    }
    .contact-item {
        display: flex;
        align-items: flex-start;
        gap: 18px;
        background: rgba(255,255,255,0.08);
        border-radius: 16px;
        padding: 18px 20px;
        box-shadow: 0 2px 8px 0 rgba(31, 38, 135, 0.10);
        transition: background 0.2s;
    }
    .contact-item:hover {
        background: rgba(255,255,255,0.18);
    }
    .contact-icon {
        font-size: 2rem;
        color: #ff6a88;
        margin-top: 2px;
        min-width: 36px;
    }
    .contact-info p {
        margin: 0;
        color: #fff;
        font-weight: 500;
        font-size: 1.05rem;
    }
    .contact-info a {
        color: #fff;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.2s;
        word-break: break-all;
    }
    .contact-info a:hover {
        color: #ff6a88;
        text-decoration: underline;
    }
    @media (max-width: 600px) {
        .glass-card {
            padding: 24px 10px;
            max-width: 98vw;
        }
        .contact-section {
            padding: 30px 0;
        }
    }
</style>

<div class="contact-section">
    <div class="glass-card">
        <h4>Contact Us</h4>
        <div class="contact-detail-list">
            <!-- Email Section -->
            <div class="contact-item">
                <span class="contact-icon"><i class="fas fa-envelope"></i></span>
                <div class="contact-info">
                    <p>Email</p>
                    <a href="mailto:info@lustyloops.com">info@lustyloops.com</a><br>
                    <a href="mailto:support@lustyloops.com">support@lustyloops.com</a>
                </div>
            </div>
            <!-- Phone Number Section -->
            <div class="contact-item">
                <span class="contact-icon"><i class="fas fa-phone"></i></span>
                <div class="contact-info">
                    <p>Phone</p>
                    <a href="tel:+1234567890">+123 456 7890</a>
                </div>
            </div>
            <!-- Address Section -->
            <div class="contact-item">
                <span class="contact-icon"><i class="fas fa-map-marker-alt"></i></span>
                <div class="contact-info">
                    <p>Address</p>
                    123 Cupid Lane, Love City, LC 45678
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Font Awesome CDN for icons (if not already included) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<?php include "footer1.php"; ?>
