<?php
include "admin/conn.php";
// Start session
session_start();
// Check if the user is already logged in
if (!empty($_SESSION["id"])) {
    header("Location: login.php");
    exit(); // Make sure to exit after redirecting
}

if (isset($_POST["submit"])) {
    $usernameemail = $_POST["usernameemail"];
    $password = $_POST["password"];

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("SELECT id, username, email, password FROM tb_user WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $usernameemail, $usernameemail);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $username, $email, $hashedPassword);
        $stmt->fetch();

        // Verify the password using password_verify
        if (password_verify($password, $hashedPassword)) {
            $_SESSION["id"] = $id;
            $_SESSION["username"] = $username;
            $_SESSION["email"] = $email;
            
            $stmt->close();
            
            header("Location: members.php");
            exit(); // Make sure to exit after redirecting
        } else {
            echo "<script>alert('Wrong Password');</script>";
        }
    } else {
        echo "<script>alert('User Not Registered');</script>";
    }

    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="lustyloops Login Page">
    <title>Login - lustyloops</title>
    <link rel="icon" type="image/png" href="images/favicon.png">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap');
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-container {
    background: rgba(34, 34, 51, 0.98);
    border-radius: 25px;
    box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
    padding: 48px 38px 38px 38px;
    max-width: 600px;
    width: 110%;
    text-align: center;
    position: relative;
    overflow: hidden;
}
        .login-container::before {
            content: '';
            position: absolute;
            top: -80px;
            left: -80px;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, #f26e65 0%, transparent 70%);
            opacity: 0.25;
            z-index: 0;
        }
        .login-container::after {
            content: '';
            position: absolute;
            bottom: -60px;
            right: -60px;
            width: 160px;
            height: 160px;
            background: radial-gradient(circle, #f5a72a 0%, transparent 70%);
            opacity: 0.18;
            z-index: 0;
        }
        .logo {
            margin-bottom: 18px;
            z-index: 1;
            position: relative;
        }
        .logo img {
            max-width: 120px;
            filter: drop-shadow(0 2px 8px #f26e6540);
        }
        .login-container h1 {
            color: #fff;
            font-size: 2.1rem;
            font-weight: 700;
            margin-bottom: 8px;
            letter-spacing: 1px;
            z-index: 1;
            position: relative;
        }
        .login-container p {
            margin-top: 8px;
            font-size: 1rem;
            color: #e0e0e0;
            margin-bottom: 26px;
            z-index: 1;
            position: relative;
        }
        .form-input {
            position: relative;
            margin-bottom: 26px;
            z-index: 1;
        }
        .form-input input {
            width: 100%;
            padding: 14px 16px 14px 44px;
            border: none;
            border-radius: 12px;
            background: rgba(255,255,255,0.07);
            color: #fff;
            font-size: 1rem;
            transition: background 0.2s, box-shadow 0.2s;
            box-shadow: 0 2px 8px 0 rgba(31, 38, 135, 0.07);
        }
        .form-input input:focus {
            background: rgba(242, 110, 101, 0.13);
            outline: none;
        }
        .form-input .input-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: #f5a72a;
            font-size: 1.1rem;
            pointer-events: none;
        }
        .form-input-checkbox {
            text-align: left;
            margin-bottom: 22px;
            z-index: 1;
            position: relative;
        }
        .form-input-checkbox label {
            margin-left: 7px;
            color: #bdbdbd;
            font-size: 0.97rem;
            cursor: pointer;
        }
        .main-btn {
            background: linear-gradient(90deg, #f26e65 0%, #f5a72a 100%);
            border: none;
            color: #fff;
            padding: 13px 0;
            width: 100%;
            font-size: 1.1rem;
            font-weight: 700;
            border-radius: 12px;
            cursor: pointer;
            box-shadow: 0 4px 16px 0 rgba(242, 110, 101, 0.13);
            transition: background 0.3s, transform 0.2s, box-shadow 0.2s;
            margin-bottom: 10px;
            z-index: 1;
            position: relative;
        }
        .main-btn:hover {
            background: linear-gradient(90deg, #f5a72a 0%, #f26e65 100%);
            transform: translateY(-2px) scale(1.03);
            box-shadow: 0 8px 24px 0 rgba(245, 167, 42, 0.18);
        }
        .login-container p a {
            color: #f5a72a;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.2s;
        }
        .login-container p a:hover {
            color: #f26e65;
            text-decoration: underline;
        }
        .additional-content {
            margin-top: 32px;
            font-size: 0.97rem;
            color: #bdbdbd;
            z-index: 1;
            position: relative;
        }
        @media (max-width: 600px) {
            .login-container {
                padding: 28px 8vw 24px 8vw;
                max-width: 98vw;
            }
            .logo img {
                max-width: 90px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <a href="home.php">
                <img src="images/logo.png" class="img-fluid" alt="logo">
            </a>
        </div>
        <h1>Welcome Back!</h1>
        <p>Connect, chat, and explore a world of possibilities.</p>
        <form method="POST" onsubmit="return validateForm();">
            <div class="form-input">
                <span class="input-icon"><i class="fas fa-user"></i></span>
                <input type="text" id="usernameemail" name="usernameemail" placeholder="Email Address / Username *" required autocomplete="username">
            </div>
            <div class="form-input">
                <span class="input-icon"><i class="fas fa-lock"></i></span>
                <input type="password" id="password" name="password" placeholder="Password *" required autocomplete="current-password">
            </div>
            <div class="form-input-checkbox">
                <input type="checkbox" id="rememberme" name="rememberme">
                <label for="rememberme">Remember me</label>
            </div>
            <button class="main-btn" name="submit" type="submit">Log In</button>
        </form>
        <p>Not a member yet? <a href="home.php">Let's Go</a> and start your journey!</p>
        <div class="additional-content">
            <p>✨ Discover new friends, share your stories, and make unforgettable memories. <br>Join us today!</p>
        </div>
    </div>
    <script>
        function validateForm() {
            const usernameemail = document.getElementById('usernameemail').value;
            const password = document.getElementById('password').value;
            if (usernameemail.trim() === '' || password.trim() === '') {
                alert('Please fill out all fields.');
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
