<?php include "header1.php";?>

<style>
/* General Styles */
body {
    background:#1D1C29;
    font-family: 'Montserrat', Arial, sans-serif;
}
.members-heading {
    text-align: center;
    font-size: 32px;
    font-weight: bold;
    color: #fff;
    margin-bottom: 30px;
    text-transform: uppercase;
    letter-spacing: 2px;
}
.profile-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
    gap: 32px;
}
.profile-card {
    background: linear-gradient(135deg, #232526 0%, #414345 100%);
    border-radius: 18px;
    overflow: hidden;
    box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
    transition: transform 0.3s, box-shadow 0.3s;
    position: relative;
    border: none;
}
.profile-card:hover {
    transform: translateY(-10px) scale(1.04);
    box-shadow: 0 16px 32px 0 rgba(31, 38, 135, 0.47);
}
.profile-image {
    position: relative;
    width: 100%;
    height: 260px;
    overflow: hidden;
    background: #222;
}
.profile-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.4s cubic-bezier(.25,.8,.25,1);
    border-bottom: 4px solid #F5735D;
    filter: grayscale(10%) brightness(0.95);
}
.profile-card:hover .profile-image img {
    transform: scale(1.12) rotate(-2deg);
    filter: grayscale(0%) brightness(1.1);
}
.image-overlay {
    position: absolute;
    top: 0; left: 0; width: 100%; height: 100%;
    background: linear-gradient(180deg, rgba(245,115,93,0.1) 0%, rgba(0,0,0,0.7) 100%);
    opacity: 0;
    transition: opacity 0.3s;
    display: flex;
    align-items: flex-end;
    justify-content: flex-end;
    padding: 18px;
}
.profile-card:hover .image-overlay {
    opacity: 1;
}
.image-overlay span {
    color: #fff;
    font-size: 18px;
    background: rgba(245,115,93,0.85);
    padding: 6px 18px;
    border-radius: 20px;
    font-weight: 600;
    letter-spacing: 1px;
    box-shadow: 0 2px 8px rgba(245,115,93,0.2);
}
.profile-info {
    padding: 22px 18px 18px 18px;
    background: rgba(24,24,24,0.92);
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-radius: 0 0 18px 18px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.12);
    position: relative;
    z-index: 2;
}
.profile-info .profile-details {
    display: flex;
    flex-direction: column;
    gap: 6px;
}
.profile-info h6 {
    margin: 0;
    font-size: 19px;
    font-weight: 700;
    color: #fff;
    letter-spacing: 0.5px;
    display: flex;
    align-items: center;
}
.profile-info .online-dot {
    width: 12px;
    height: 12px;
    background: linear-gradient(135deg, #7fff00 0%, #00ff90 100%);
    border-radius: 50%;
    margin-right: 8px;
    box-shadow: 0 0 8px #00ff90;
    display: inline-block;
}
.profile-info .location {
    font-size: 15px;
    color: #F5735D;
    display: flex;
    align-items: center;
    gap: 4px;
    font-weight: 500;
}
.profile-info .location i {
    color: #F5735D;
}
.profile-info .chat-btn {
    background: linear-gradient(90deg, #F5735D 0%, #ffb347 100%);
    color: #fff;
    border: none;
    padding: 8px 28px;
    border-radius: 22px;
    font-size: 15px;
    font-weight: 600;
    display: flex;
    align-items: center;
    cursor: pointer;
    box-shadow: 0 2px 8px rgba(245,115,93,0.18);
    transition: background 0.2s;
}
.profile-info .chat-btn:hover {
    background: linear-gradient(90deg, #ffb347 0%, #F5735D 100%);
}
@media (max-width: 900px) {
    .profile-grid { grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); }
    .profile-image { height: 180px; }
}
@media (max-width: 600px) {
    .profile-info { flex-direction: column; gap: 12px; align-items: flex-start; }
    .profile-card { border-radius: 12px; }
}
</style>

<div style="background: #1D1C29; width: 100%; float: left; padding: 35px 0;">
    <div style="width: 92%; margin: 0 auto;">
        <div class="members-heading">Meet Our Members</div>
        <div class="profile-grid">

            <?php
            include("admin/conn.php");

            $stmt = $conn->prepare("SELECT * FROM add_adver ORDER BY RAND() LIMIT 54");
            $stmt->execute();
            $result = $stmt->get_result();

            while ($row = $result->fetch_assoc()):
            ?>
            <div class="profile-card">
                <a href="profile.php?category=<?= $row['id']; ?>" style="text-decoration: none; color: inherit;">
                    <div class="profile-image">
                        <img src="admin/pic/<?= $row['product_img']; ?>" alt="profile-img">
                        <div class="image-overlay">
                            <span><i class="fa fa-eye" aria-hidden="true"></i> View Profile</span>
                        </div>
                    </div>
                    <div class="profile-info">
                        <div class="profile-details">
                            <h6>
                                <span class="online-dot"></span>
                                <?= htmlspecialchars($row['name']); ?>
                            </h6>
                            <span class="location">
                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                <?= htmlspecialchars($row['country']); ?>
                            </span>
                        </div>
                        <button class="chat-btn">
                            <i class="fa fa-comment" aria-hidden="true" style="margin-right: 7px;"></i> Chat
                        </button>
                    </div>
                </a>
            </div>
            <?php endwhile; ?>

        </div>
    </div>
</div>


<?php include "footer1.php";?>