<?php include "header1.php"; ?>
<style>
	body {
		background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
		font-family: 'Segoe UI', Arial, sans-serif;
		margin: 0;
		padding: 0;
	}
	.profile-container {
		max-width: 900px;
		margin: 40px auto;
		background: rgba(24, 24, 36, 0.98);
		border-radius: 18px;
		box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
		padding: 40px 30px 30px 30px;
		border: 1px solid rgba(255,255,255,0.08);
	}
	.profile-header {
		display: flex;
		align-items: center;
		gap: 32px;
		margin-bottom: 32px;
	}
	.profile-img-wrapper {
		width: 180px;
		height: 180px;
		border-radius: 50%;
		overflow: hidden;
		border: 4px solid #ff5722;
		box-shadow: 0 4px 16px rgba(255,87,34,0.15);
		background: #fff;
		flex-shrink: 0;
	}
	.profile-img-wrapper img {
		width: 100%;
		height: 100%;
		object-fit: cover;
		border-radius: 50%;
	}
	.profile-main-info {
		flex: 1;
		color: #fff;
	}
	.profile-main-info h2 {
		margin: 0 0 10px 0;
		font-size: 2.2em;
		font-weight: 700;
		color: #ff5722;
		letter-spacing: 1px;
	}
	.profile-main-info .profile-meta {
		display: flex;
		gap: 18px;
		margin-bottom: 12px;
		font-size: 1.1em;
	}
	.profile-main-info .profile-meta span {
		display: flex;
		align-items: center;
		gap: 6px;
		color: #f5f5f5;
		background: rgba(255,255,255,0.07);
		padding: 4px 12px;
		border-radius: 16px;
	}
	.profile-actions {
		margin-top: 18px;
		display: flex;
		gap: 18px;
	}
	.profile-actions button {
		padding: 12px 28px;
		background: linear-gradient(90deg, #ff5722 0%, #ff9800 100%);
		border: none;
		color: #fff;
		font-size: 1.1em;
		border-radius: 24px;
		cursor: pointer;
		font-weight: 600;
		box-shadow: 0 2px 8px rgba(255,87,34,0.12);
		transition: background 0.2s, transform 0.2s;
		display: flex;
		align-items: center;
		gap: 8px;
	}
	.profile-actions button:hover {
		background: linear-gradient(90deg, #ff9800 0%, #ff5722 100%);
		transform: translateY(-2px) scale(1.04);
	}
	.profile-details {
		display: flex;
		gap: 32px;
		margin-top: 24px;
		flex-wrap: wrap;
	}
	.profile-about, .profile-info {
		flex: 1 1 320px;
		background: rgba(255,255,255,0.04);
		padding: 24px;
		border-radius: 14px;
		color: #fff;
		box-shadow: 0 2px 8px rgba(0,0,0,0.06);
	}
	.profile-about h3, .profile-info h3 {
		margin-top: 0;
		color: #ff9800;
		font-size: 1.3em;
		margin-bottom: 10px;
		font-weight: 600;
	}
	.profile-info ul {
		list-style: none;
		padding: 0;
		margin: 0;
	}
	.profile-info li {
		margin-bottom: 10px;
		font-size: 1.07em;
		color: #f5f5f5;
	}
	.profile-info li strong {
		color: #ff5722;
		font-weight: 600;
		margin-right: 6px;
	}
	@media (max-width: 800px) {
		.profile-header, .profile-details {
			flex-direction: column;
			gap: 20px;
		}
		.profile-container {
			padding: 18px 6px;
		}
	}
	.dark .top-main-wrapper {
    position: relative;
    width: 100%;
    height: 100%;
    min-height: 730px;
    background: url(../images/darkmodemain-bg.png) center center / cover no-repeat;
}

/* Overlay with #1D1C29 + opacity */
.dark .top-main-wrapper::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
    background-color: rgba(29, 28, 41, 0.8); /* #1D1C29 with 80% opacity */
    z-index: 1;
}

/* Optional: add content above the overlay */
.dark .top-main-wrapper > * {
    position: relative;
    z-index: 2;
}

</style>
<div class="profile-container">
	<?php 
		include("admin/conn.php");
		$stmt = $conn->prepare("SELECT * FROM add_adver WHERE id=?");
		$stmt->bind_param("i", $_GET['category']);
		$stmt->execute();
		$result = $stmt->get_result();
		while ($row = $result->fetch_assoc()): 
	?>
	<div class="profile-header">
		<div class="profile-img-wrapper">
			<img src="admin/pic/<?= htmlspecialchars($row['product_img']); ?>" alt="Profile Image">
		</div>
		<div class="profile-main-info">
			<h2><?= htmlspecialchars($row['name']); ?></h2>
			<div class="profile-meta">
				<span><i class="fas fa-map-marker-alt" style="color:#ff9800;"></i> <?= htmlspecialchars($row['country']); ?></span>
				<span><i class="fas fa-language" style="color:#ff9800;"></i> <?= htmlspecialchars($row['languge']); ?></span>
				<span><i class="fas fa-users" style="color:#ff9800;"></i> <span id="followerCount"></span> Followers</span>
			</div>
			<div class="profile-actions">
				<button onclick="window.location.href='upgrade.php';"><i class="fas fa-comments"></i> Chat</button>
				<button onclick="window.location.href='upgrade.php';"><i class="fas fa-heart"></i> Like</button>
			</div>
		</div>
	</div>
	<div class="profile-details">
		<div class="profile-about">
			<h3>About Me</h3>
			<p><?= nl2br(htmlspecialchars($row['about'])); ?></p>
		</div>
		<div class="profile-info">
			<h3>Personal Info</h3>
			<ul>
				<li><strong>Country:</strong> <?= htmlspecialchars($row['country']); ?></li>
				<li><strong>Diet:</strong> <?= htmlspecialchars($row['diet']); ?></li>
				<li><strong>Height:</strong> <?= htmlspecialchars($row['height']); ?></li>
				<li><strong>Education:</strong> <?= htmlspecialchars($row['education']); ?></li>
				<li><strong>Language:</strong> <?= htmlspecialchars($row['languge']); ?></li>
				<li><strong>Smoking:</strong> <?= htmlspecialchars($row['smooking']); ?></li>
				<li><strong>Eye Color:</strong> <?= htmlspecialchars($row['color']); ?></li>
				<li><strong>Work:</strong> <?= htmlspecialchars($row['work']); ?></li>
			</ul>
		</div>
	</div>
	<?php endwhile; ?>
</div>
<script>
	function getRandomFollowerCount(min, max) {
		return Math.floor(Math.random() * (max - min + 1)) + min;
	}
	document.addEventListener('DOMContentLoaded', function() {
		var followerCountElement = document.getElementById('followerCount');
		if (followerCountElement) {
			var randomFollowerCount = getRandomFollowerCount(10000, 150000);
			followerCountElement.innerText = randomFollowerCount.toLocaleString();
		}
	});
</script>
<?php include "footer1.php"; ?>